
<!DOCTYPE html>
<html lang="zxx" class="js">

<head>

    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Recharge and get paid">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logo/favicon.png')); ?>">
    <!-- Page Title  -->
    <title><?php echo e(isset($page_title) ? $page_title : ''); ?> | <?php echo e($basic->sitename); ?></title>
    <!-- StyleSheets  -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/dashlite-63021.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/skins/theme-red.css')); ?>">
    <link href="<?php echo e(asset('frontend/css/jquery.growl.css')); ?>" rel="stylesheet" />
</head>

<body class="nk-body npc-crypto ui-clean pg-auth">
    <!-- app body @s  -->
    <div class="nk-app-root">
        <div class="nk-split nk-split-page nk-split-md">
            <div class="nk-split-content nk-block-area nk-block-area-column nk-auth-container bg-white">
                <div class="absolute-top-right d-lg-none p-3 p-sm-5">
                    <a href="#" class="toggle btn-white btn btn-icon btn-light" data-target="athPromo"><em class="icon ni ni-info"></em></a>
                </div>
                <div class="nk-block nk-block-middle nk-auth-body">
                    
                    <div class="nk-block-head">
                        <div class="nk-block-head-content">
                            <h3 class="form-label" for="default-01">Already a user? Login</h3>
                        </div>
                    </div><!-- .nk-block-head -->

                    
                    <form action="<?php echo e(route('login')); ?>" method="post" class="form" novalidate="">
                    <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <div class="form-label-group">
                                <label class="form-label" for="default-01"><?php echo e($basic->sitename); ?>Tag (username)</label>
                                <a class="link link-primary link-sm" tabindex="-1" href="https://api.whatsapp.com/send?phone=2348148620913&text=Hello%20ZuwaPay" target="_target">Need Help?</a>
                            </div>
                            <input type="text" name="username" class="form-control form-control-lg" id="default-01" placeholder="Enter your <?php echo e($basic->sitename); ?>Tag">
                        </div><!-- .foem-group -->
                        <div class="form-group">
                            <div class="form-label-group">
                                <label class="form-label" for="password">Password</label>
                                <a class="link link-primary link-sm" tabindex="-1" href="<?php echo e(route('user.password.request')); ?>">Forgot Code?</a>
                            </div>
                            <div class="form-control-wrap">
                                <a tabindex="-1" href="#" class="form-icon form-icon-right passcode-switch" data-target="password">
                                    <em class="passcode-icon icon-show icon ni ni-eye"></em>
                                    <em class="passcode-icon icon-hide icon ni ni-eye-off"></em>
                                </a>
                                <input type="password" name="password" class="form-control form-control-lg" id="password" placeholder="Enter your password">
                            </div>
                        </div><!-- .foem-group -->
                        <div class="form-group">
                            <button class="btn btn-lg btn-primary btn-block">Sign in</button>
                        </div>
                    </form><!-- form -->

                    <div class="text-center pt-4 pb-3">
                        <h6 class="overline-title overline-title-sap"><span>OR REGISTER</span></h6>
                    </div>
                    
                    <div class="nav-item"><a class="nav-link" href="<?php echo e(route('register')); ?>" >
                            <button class="btn btn-lg btn-primary btn-block">Create a New Account</button>
                        </div>
                    
                   

                </div><!-- .nk-block -->
                <div class="nk-block nk-auth-footer">
                    <div class="nk-block-between">
                        <ul class="nav nav-sm">
                         
                            <li class="nav-item">
                               <a class="nav-link" href="#">&copy; <?php echo e(date('Y')); ?></a> | <a class="nav-link" href="#"><?php echo e($basic->sitename); ?></a>
                            </li>
                            

                        </ul><!-- .nav -->
                    </div>
                    <div class="mt-3">

                    </div>
                </div><!-- .nk-block -->
            </div><!-- .nk-split-content -->
            <div class="nk-split-content nk-split-stretch bg-lighter d-flex toggle-break-lg toggle-slide toggle-slide-right" data-content="athPromo" data-toggle-screen="lg" data-toggle-overlay="true">
                <div class="slider-wrap w-100 w-max-550px p-3 p-sm-5 m-auto">
                    <div class="slider-init" data-slick='{"dots":true, "arrows":false}'>

                        <div class="slider-item">
                            <div class="nk-feature nk-feature-center">
                                <div class="nk-feature-img">
                                    <img class="round" src="<?php echo e(asset('core-img/mobile-banking.png')); ?>" srcset="<?php echo e(asset('core-img/mobile-banking.png')); ?> 2x" alt="">
                                </div>
                                <div class="nk-feature-content py-4 p-sm-5">
                                    <h4><?php echo e($basic->sitename); ?></h4>
                                    <p>You can start earning while paying your bills. Simply login to explore our products and enjoy the possibilities</p>
                                </div>
                            </div>
                        </div><!-- .slider-item -->
                    </div><!-- .slider-init -->
                    <div class="slider-dots"></div>
                    <div class="slider-arrows"></div>
                </div><!-- .slider-wrap -->
            </div><!-- .nk-split-content -->
        </div><!-- .nk-split -->
    </div><!-- app body @e  -->
    <!-- JavaScript -->
 <script src="<?php echo e(asset('backend/js/bundle.js?ver=1.6.1')); ?>"></script>
 <script src="<?php echo e(asset('backend/js/scripts.js?ver=1.6.1')); ?>"></script>
<?php echo $__env->yieldContent('script'); ?>
    <script src="<?php echo e(asset('frontend/js/rainbow.js')); ?>"></script>
	<script src="<?php echo e(asset('frontend/js/sample.js')); ?>"></script>
	<script src="<?php echo e(asset('frontend/js/jquery.growl.js')); ?>"></script>



<?php echo $__env->yieldContent('js'); ?>
<?php if(session('alert')): ?>
	<script>
		 (function () {
		  $(function () {
		   return $.growl.error({
				message: "<?php echo e(session('alert')); ?>"
			});
  		  });
		}).call(this);
 	</script>
<?php endif; ?>


<?php if($errors->has('fname')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.error({
				message: "<?php echo e($errors->first('fname')); ?>"
			});
  		  });
		}).call(this);
 	</script>
<?php endif; ?>

<?php if($errors->has('lname')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.error({
				message: "<?php echo e($errors->first('lname')); ?>"
			});
  		  });
		}).call(this);
 	</script>
<?php endif; ?>
<?php if($errors->has('username')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.error({
				message: "<?php echo e($errors->first('username')); ?>"
			});
  		  });
		}).call(this);
 	</script>
<?php endif; ?>
<?php if($errors->has('phone')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.error({
				message: "<?php echo e($errors->first('phone')); ?>"
			});
  		  });
		}).call(this);
 	</script>
<?php endif; ?>
<?php if($errors->has('email')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.error({
				message: "<?php echo e($errors->first('email')); ?>"
			});
  		  });
		}).call(this);
 	</script>
<?php endif; ?>
<?php if($errors->has('password')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.error({
				message: "<?php echo e($errors->first('password')); ?>"
			});
  		  });
		}).call(this);
 	</script>
<?php endif; ?>


<?php if(Session::has('success')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.notice({
				message: "<?php echo e(Session::get('success')); ?>"
			});
  		  });
		}).call(this);
 	</script>
 <?php endif; ?>

<?php if(session('message')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.notice({
				message: "<?php echo e(session('message')); ?>"
			});
  		  });
		}).call(this);
 	</script>
 <?php endif; ?>
<?php if(Session::has('danger')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.error({
				message: "<?php echo e(session('danger')); ?>"
			});
  		  });
		}).call(this);
 	</script>
 <?php endif; ?>

 <?php if($errors->has('sms_code')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.error({
				message: "<?php echo e($errors->first('sms_code')); ?>"
			});
  		  });
		}).call(this);
 	</script>
<?php endif; ?>

 <?php if($errors->has('email_code')): ?>
<script>
		 (function () {
		  $(function () {
		   return $.growl.error({
				message: "<?php echo e($errors->first('email_code')); ?>"
			});
  		  });
		}).call(this);
 	</script>
<?php endif; ?>
<?php if(Session::has('ref')): ?>
<script>
 swal("Hello", "<?php echo session()->get('ref'); ?>", "info");
</script>
<?php endif; ?>
<?php if(Session::has('referror')): ?>
<script>
 swal("Hello", "<?php echo session()->get('referror'); ?>", "error");
</script>
<?php endif; ?>



</body></html>
<!-- Localized -->
